float4x4 mWorldViewProj;
float4x4 mWorldViewInv;

struct VS_OUTPUT
{
    float4 Position		: POSITION;   // vertex position 
    float2 uv			: TEXCOORD0;
    float3 Normal		: TEXCOORD1;
    float3 SecPos		: TEXCOORD2;
};

VS_OUTPUT main( in float4 pos : POSITION,
				in float2 uv : TEXCOORD0,
				in float3 normal : NORMAL)
{
	VS_OUTPUT Output;
		
    Output.Position = mul(pos, mWorldViewProj);
    Output.Normal = mul(mWorldViewInv, normal);
    Output.uv = uv;
    Output.SecPos = Output.Position;
    
    
    return Output;
}